'use strict';

function UserDashboardController(
  $scope,
  $api,
  $user,
  $location,
  $window,
  $focus) {
  var ctrl = this;
  ctrl.user = {};
  ctrl.username = null;
  ctrl.lastRefreshedData = {};
  ctrl.availableUserData = false;
  ctrl.lastRefreshedTime = '';

  ctrl.submitSearch = function (form) {
    if (!form.$valid) {
      $window.alert('Only alphanumeric characters are valid.');
      ctrl.username = null;
      return false;
    }
    if (!ctrl.username) {
      $window.alert('Please Enter a Username.');
      ctrl.username = null;
      return false;
    }

    ctrl.availableUserData = false;
    ctrl.user = {};

    console.log('MADE IT');
    return $api.retrieve('users/username/' + ctrl.username, {})
      .then(function (userSearch) {
        if (userSearch.success && userSearch.response) {
          ctrl.availableUserData = true;
          ctrl.user = userSearch.response;
          $focus('sysAdminDashHeader');
        } else {
          $window.alert(userSearch.message);
        }
        ctrl.username = null;
      });
  };

  ctrl.refreshUsers = function () {
    return $api.retrieve('users/ldapRefresh/' + $user.username(), {})
      .then(function (ldapRefresh) {
        ctrl.lastRefreshedData = {};
        if (ldapRefresh.success && ldapRefresh.response) {
          ctrl.lastRefreshedData = ldapRefresh.response;
          ctrl.lastRefreshedTime = ctrl.lastRefreshedData.lastRefreshed;
        } else {
          $window.alert(ldapRefresh.message);
        }
      });
  };

  ctrl.lastRefreshed = function () {
    return $api.retrieve('users/lastRefreshed', {})
      .then(function (lastRefresh) {
        ctrl.lastRefreshedData = {};
        if (lastRefresh.success && lastRefresh.response) {
          ctrl.lastRefreshedData = lastRefresh.response;
          ctrl.lastRefreshedTime = ctrl.lastRefreshedData.lastRefreshed;
        } else {
          $window.alert(lastRefresh.message);
        }
      });
  };

  ctrl.$onInit = function () {
    ctrl.lastRefreshed();
  };
}

angular.module('genisis').component('userDashboard', {
  templateUrl: 'systemAdministration/userDashboard.html',
  controller: ['$scope', 'api', 'user', '$location', '$window',
    'focus', UserDashboardController
  ],
  bindings: {
    user: '<',
    username: '<',
    lastRefreshedTime: '<',
    lastRefreshedData: '<',
    availableUserData: '@'
  }
});